## Description of the Task Behind These Data
  
These participant files come from a simple N-back working-memory task, which is commonly used to study cognitive load. On each trial, participants see a sequence of stimuli (such as letters or shapes) and must decide whether the current item matches one seen N items earlier.

+ In a 1-back (low-load) condition, participants compare the current item to the immediately previous item.
+ This requires only minimal working memory and is usually fast and accurate.
+ In a 4-back (high-load) condition, participants compare the current item to the one shown four trials earlier.
+ This is much harder and places a higher demand on working memory, leading to slower responses and more errors.

## The CSV files reflect this pattern:

+ `condition` indicates whether the trial was 1-back (low_load) or 4-back (high_load)
+ `rt` contains the reaction time for each response, with slower and more variable times expected under high load
+ `correct` shows whether the participant responded accurately, with accuracy typically lower in the high-load condition
+ Some trials include missing RTs (`NA`), mimicking occasional lapses or recording issues

These simplified data let you practice filtering, summarizing, and analyzing performance differences between cognitive-load conditions.